VERSION 5.00
Begin VB.Form SglePoint 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "DAC-02 Single Output Menu"
   ClientHeight    =   3030
   ClientLeft      =   1095
   ClientTop       =   1845
   ClientWidth     =   4485
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   3030
   ScaleWidth      =   4485
   Begin VB.Frame Frame2 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Output Voltage"
      ForeColor       =   &H80000008&
      Height          =   975
      Left            =   360
      TabIndex        =   4
      Top             =   1680
      Width           =   2295
      Begin VB.TextBox OutVolt 
         Appearance      =   0  'Flat
         Height          =   285
         Left            =   480
         MaxLength       =   6
         TabIndex        =   5
         Text            =   "0"
         Top             =   480
         Width           =   975
      End
   End
   Begin VB.CommandButton sgleclose 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "&Close"
      Height          =   495
      Left            =   3000
      TabIndex        =   3
      Top             =   2160
      Width           =   1095
   End
   Begin VB.CommandButton sgleout 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "&Output"
      Height          =   495
      Left            =   3000
      TabIndex        =   2
      Top             =   1320
      Width           =   1095
   End
   Begin VB.Frame Frame1 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Channel"
      ForeColor       =   &H80000008&
      Height          =   975
      Left            =   360
      TabIndex        =   0
      Top             =   360
      Width           =   2295
      Begin VB.TextBox chan 
         Appearance      =   0  'Flat
         Height          =   285
         Left            =   960
         MaxLength       =   1
         TabIndex        =   1
         Text            =   "0"
         Top             =   480
         Width           =   255
      End
   End
End
Attribute VB_Name = "SglePoint"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim OutputData As Integer   ' Integer number written to port I/O
Dim Gain As Single          ' Gain adjusted based on channel config
Dim Offset As Integer       ' Offset adjusted based on channel config

Private Sub chan_GotFocus()
    sgleout.Default = True
End Sub

Private Sub chan_KeyPress(KeyAscii As Integer)
' Only accept 0 and 1
    If Not ((KeyAscii >= &H30 And KeyAscii <= &H31) Or KeyAscii = &H8) Then
        KeyAscii = 0
    End If
End Sub

Private Sub Form_Load()
    OutputData = 0
    UpdateVolts
    sgleout.Default = True
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Call sgleClose_Click
End Sub

Private Sub OutVolt_Change()
    On (Config.Range(Val(SglePoint.chan.Text)).ListIndex) + 1 GoTo 10, 11, 12, 13
10
    Offset = 0
    Gain = 819.2
    GoTo 14
11
    Offset = 0
    Gain = 409.6
    GoTo 14
12
    Offset = 2048
    Gain = -409.6
    GoTo 14
13
    Offset = 2048
    Gain = -204.8
14  ' Convert to integer
    OutputData = Val(OutVolt.Text) * Gain + Offset
    If OutputData < 0 Then OutputData = 0
    If OutputData > 4095 Then OutputData = 4095

End Sub

Private Sub OutVolt_KeyPress(KeyAscii As Integer)
'Only take 0-9, ".", backspace and "-"
    If Not ((KeyAscii >= &H30 And KeyAscii <= &H39) Or KeyAscii = &H2E Or KeyAscii = &H2D Or KeyAscii = &H8) Then
        KeyAscii = 0
    End If
End Sub

Private Sub sgleClose_Click()
    SglePoint.Hide
    Main.Show
End Sub

Private Sub sgleout_Click()
Dim ochan As Integer    'Output channel
Dim HByte As Integer    'High byte
Dim LByte As Integer    'Low byte

    ochan = Val(chan.Text)

    HByte = Int(OutputData / 16)
    LByte = 16 * (OutputData - HByte * 16)

    'DasErr = dasbyteout(CardBase + 2 * ochan, LByte)
    DlPortWritePortUchar CardBase + 2 * ochan, LByte
    'DasErr = dasbyteout(CardBase + 2 * ochan + 1, HByte)
    DlPortWritePortUchar CardBase + 2 * ochan + 1, HByte

End Sub

Private Sub UpdateVolts()
Dim tstr As String
    On (Config.Range(Val(SglePoint.chan.Text)).ListIndex) + 1 GoTo 0, 1, 2, 3
0
    Offset = 0          ' Unipolar
    Gain = 819.2
    GoTo 4
1
    Offset = 0
    Gain = 409.6
    GoTo 4
2
    Offset = 2048       ' Bipolar
    Gain = -409.6
    GoTo 4
3
    Offset = 2048
    Gain = -204.8
4   ' Convert to voltage display
    OutVolt.Text = Str((OutputData - Offset) / Gain)
End Sub

